<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Dashboard Sidebar</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="<?=base_url() ?>Assets/css/all.min.css" rel="stylesheet" >

    <style>
        body {
            display: flex;
            flex-direction: column;
            min-height: 100vh;
            overflow: hidden;
        }
        .header {
            width: 100%;
            background: #343a40;
            color: white;
            padding: 10px;
            text-align: center;
        }
        .sidebar {
            width: 250px;
            height: 100vh;
            background: #343a40;
            color: white;
            transition: 0.3s;
            position: fixed;
            top: 50px;
            left: 0;
            overflow: hidden;
            display: flex;
            flex-direction: column;
        }
        .sidebar a {
            color: white;
            padding: 10px;
            display: flex;
            align-items: center;
            text-decoration: none;
        }
        .sidebar a i {
            margin-right: 10px;
            font-size: 20px;
        }
        .sidebar a span {
            display: inline-block;
            transition: opacity 0.3s ease;
        }
        .sidebar a:hover {
            background: #495057;
        }
        .sidebar.collapsed {
            width: 65px;
        }
        .sidebar.collapsed a span {
            opacity: 0;
        }
        .content {
            flex: 1;
            padding: 20px;
            margin-left: 250px;
            transition: margin-left 0.3s;
        }
        .toggle-btn {
            background: #343a40;
            color: white;
            border: none;
            padding: 10px;
            cursor: pointer;
        }
        @media (max-width: 768px) {
            .sidebar {
                width: 250px;
                left: -250px;
                position: fixed;
                z-index: 1000;
                top: 50px;
                height: 100%;
            }
            .sidebar.open {
                left: 0;
            }
            .content {
                margin-left: 0;
                transition: 0.3s;
            }
            .toggle-btn {
                position: absolute;
                top: 10px;
                left: 10px;
                z-index: 1100;
            }
        }
    </style>
</head>
<body>
    <div class="header " style="height:70px">
        <button class="toggle-btn" onclick="toggleSidebar()">☰ </button>
    </div>


    <div class="sidebar" id="sidebar">
        <a href="#"><i class="fas fa-home"></i><span>  dask</span></a>
        <a href="#"><i class="fas fa-folder"></i><span>  Projectse</span></a>
        <a href="#"><i class="fas fa-chart-bar"></i><span>Reports</span></a>
        <a href="#"><i class="fas fa-cog"></i><span>Settings</span></a>
    </div>
    <div class="content" id="content">
        <h2>Admin Dashboard</h2>
        <p>Welcome to your dashboard!</p>
    </div>
    
    <script src="https://kit.fontawesome.com/a076d05399.js" crossorigin="anonymous"></script>
    <script>
        function toggleSidebar() {
            let sidebar = document.getElementById("sidebar");
            let content = document.getElementById("content");
            sidebar.classList.toggle("open");
            if (window.innerWidth <= 768) {
                if (sidebar.classList.contains("open")) {
                    sidebar.style.left = "0";
                } else {
                    sidebar.style.left = "-250px";
                }
            } else {
                sidebar.classList.toggle("collapsed");
                if (sidebar.classList.contains("collapsed")) {
                    content.style.marginLeft = "80px";
                } else {
                    content.style.marginLeft = "250px";
                }
            }
        }
    </script>
</body>
</html>
